/* 
 * File:   main.c
 *
 * Created on February 9, 2010, 10:53 AM
 */
/*******************************************************************************
Copyright (c) 2014 released Microchip Technology Inc.  All rights reserved.

Microchip licenses to you the right to use, modify, copy and distribute
Software only when embedded on a Microchip microcontroller or digital signal
controller that is integrated into your product or third party product
(pursuant to the sublicense terms in the accompanying license agreement).

You should refer to the license agreement accompanying this Software for
additional information regarding your rights and obligations.

SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF
MERCHANTABILITY, TITLE, NON-INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE.
IN NO EVENT SHALL MICROCHIP OR ITS LICENSORS BE LIABLE OR OBLIGATED UNDER
CONTRACT, NEGLIGENCE, STRICT LIABILITY, CONTRIBUTION, BREACH OF WARRANTY, OR
OTHER LEGAL EQUITABLE THEORY ANY DIRECT OR INDIRECT DAMAGES OR EXPENSES
INCLUDING BUT NOT LIMITED TO ANY INCIDENTAL, SPECIAL, INDIRECT, PUNITIVE OR
CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF PROCUREMENT OF
SUBSTITUTE GOODS, TECHNOLOGY, SERVICES, OR ANY CLAIMS BY THIRD PARTIES
(INCLUDING BUT NOT LIMITED TO ANY DEFENSE THEREOF), OR OTHER SIMILAR COSTS.
*******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <p33Fxxxx.h>
#include <xc.h>
#include <spi.h>

#include "define.h"
#include "DRV_MCP2515.h"
#include "user.h"

_FOSCSEL(FNOSC_PRIPLL);
_FOSC(FCKSM_CSDCMD & OSCIOFNC_OFF & POSCMD_XT);
_FWDT(FWDTEN_OFF);

int main(int argc, char** argv) {

    // Initialization
    initClock();
    initIOPorts();
    initCANport();

    DRV_MCP2515_RX_MSGOBJ rxObj;
    DRV_MCP2515_REG_BUFFER_STATUS canStatus;
    DRV_MCP2515_MODULE_EVENT events;
    ButtonState btnState;
    uint16_t i = 0;

    // CAN data buffers
    unsigned char txd[8];
    unsigned char rxd[8];

    for (i=0; i<8; i++) {
        txd[i] = 0;
        rxd[i] = 0;
    }

    /* CAN Messages */
    // Button status
    DRV_MCP2515_TX_MSGOBJ buttonChangedMsg;
    buttonChangedMsg.id.SID = MSG_ID_BUTTON_STATUS;
    buttonChangedMsg.id.EID = 0;
    buttonChangedMsg.ctrl.DLC = 1;
    buttonChangedMsg.ctrl.IDE = 0;
    buttonChangedMsg.ctrl.RTR = 0;

    while(1) {
        // Check for received messages

        // Debounce switches
        btnState = debounceButtons();

        // Transmit Button status on change
        if (btnState.Changed) {
            txd[0] = btnState.State;

            // Wait till transmit complete
            do {
                canStatus = DRV_MCP2515_BufferStatusGet();
                Nop(); Nop();
            } while (canStatus.TX0REQ);
            Nop(); Nop(); Nop();

            DRV_MCP2515_TransmitChannelLoad(DRV_MCP2515_TX_CH0, &buttonChangedMsg, txd, buttonChangedMsg.ctrl.DLC);
            Nop(); Nop();

            // Request to send
            DRV_MCP2515_TransmitChannelFlush(DRV_MCP2515_TX_CH0);
            Nop(); Nop();

            // LEDs
            updateButtonLeds(btnState);
        }

        // Check for received message, and update LEDs
        events = DRV_MCP2515_ModuleEventGet();
        Nop(); Nop();

        // Check RXB1
        if (events & DRV_MCP2515_RXB1_EVENT) {
            // Get message
            DRV_MCP2515_ReceiveMessageGet(DRV_MCP2515_RX_CH1, &rxObj, rxd, 1);
            Nop(); Nop(); Nop();

            // Clear flag
            DRV_MCP2515_ModuleEventClear(DRV_MCP2515_RXB1_EVENT);

            //LEDs
            updateRxLeds(rxd);
        }
        Nop(); Nop();

        // Check RXB0
        if (events & DRV_MCP2515_RXB0_EVENT) {
            // Get message
            DRV_MCP2515_ReceiveMessageGet(DRV_MCP2515_RX_CH0, &rxObj, rxd, 1);
            Nop(); Nop(); Nop();

            // Clear flag
            DRV_MCP2515_ModuleEventClear(DRV_MCP2515_RXB0_EVENT);

            //LEDs
            updateRxLeds(rxd);
        }
        Nop(); Nop();
    }
    return (EXIT_SUCCESS);
}
